package gov.va.vinci.dart.biz;

import java.util.Date;
import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestParticipant extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);

		Location location = pers.getLocation();
		Assert.assertNotNull(location);
		Assert.assertTrue(location.getId() > 0);

		ResearchStudy rs = ResearchStudy.create("test activity 1", new Date(), new Date(), "official name", "DNS");
		Assert.assertNotNull(rs);
		Assert.assertTrue(rs.getId() > 0);
		
		DartRequest request = DartRequest.create("test request 1 for activity 1", new Date(), new Date(), pers, rs, "DNS");
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);
		
		if (rs.getRequests().contains(request) == false) {
			rs.getRequests().add(request);
		}
		
		request.setPrimaryLocation(pers.getLocation());
		
		Participant part = Participant.create(pers, request, location, true, true, false);
		Assert.assertNotNull(part);
		Assert.assertTrue(part.getId() > 0);

		Participant part2 = Participant.find(request.getId(), pers.getId(), location.getId());
		Assert.assertNotNull(part2);
		Assert.assertTrue(part2.getId() > 0);
		Assert.assertEquals(part2, part);
		
		Participant part3 = Participant.findPrincipalInvestigator(request.getId(), location.getId());
		if (part3 != null) {
			Assert.assertTrue(part3.getId() > 0);
			Assert.assertNotEquals(part3, part);
		}

	}

	@Test
	public void testTwo() throws Exception {
		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);

		Location location = pers.getLocation();
		Assert.assertNotNull(location);
		Assert.assertTrue(location.getId() > 0);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		Participant part = Participant.create(pers, request, location, true, true, false);
		Assert.assertNotNull(part);
		Assert.assertTrue(part.getId() > 0);
		
		int participantId = part.getId();

		Participant part2 = Participant.findById(participantId);
		Assert.assertNotNull(part2);
		Assert.assertTrue(part2.getId() > 0);
		Assert.assertEquals(part2, part);

		part.delete();
		
		Participant part3 = Participant.findById(participantId);
		Assert.assertNull(part3);
	}

	@Test
	public void testThree() throws Exception {
		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);

		Location location = pers.getLocation();
		Assert.assertNotNull(location);
		Assert.assertTrue(location.getId() > 0);

		ResearchStudy rs = ResearchStudy.create("test activity 1", new Date(), new Date(), "official name", "DNS");
		Assert.assertNotNull(rs);
		Assert.assertTrue(rs.getId() > 0);
		
		DartRequest request = DartRequest.create("test request 1 for activity 1", new Date(), new Date(), pers, rs, "DNS");
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);
		
		if (rs.getRequests().contains(request) == false) {
			rs.getRequests().add(request);
		}
		
		request.setPrimaryLocation(pers.getLocation());
		
		// and that needs a primary investigator
		Participant part = Participant.create(pers, request, pers.getLocation(), true, true, true);
		request.getParticipants().add(part);

		Assert.assertNotNull(part);
		Assert.assertTrue(part.getId() > 0);

		Participant part2 = Participant.findPrincipalInvestigator(request.getId(), location.getId());
		Assert.assertNotNull(part2);
		Assert.assertTrue(part2.getId() > 0);
		Assert.assertEquals(part2, part);
	}
}
